<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:25.539511296 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A65AE" />
    <supported-cpuid id="Neoverse-E1" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleNeoverseE1CPU_CYCLES &gt; 0), ($InstructionsPerCycleNeoverseE1INST_RETIRED / $InstructionsPerCycleNeoverseE1CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Neoverse-E1)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesNeoverseE1CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesNeoverseE1STALL_FRONTEND / $FrontendStalledCyclesNeoverseE1CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesNeoverseE1CPU_CYCLES &gt; 0), min(($BackendStalledCyclesNeoverseE1STALL_BACKEND / $BackendStalledCyclesNeoverseE1CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the percentage of instructions speculatively executed that are subsequently retired" expression="if(($RetiredInstructionsPercentageNeoverseE1INST_SPEC &gt; 0), min(($RetiredInstructionsPercentageNeoverseE1INST_RETIRED / $RetiredInstructionsPercentageNeoverseE1INST_SPEC), 1), 0)" name="Retired Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the ratio of direct branches retired to the total number of branches architecturally executed" expression="if(($BranchDirectPercentageNeoverseE1BR_RETIRED &gt; 0), min(($BranchDirectPercentageNeoverseE1BR_IMMED_RETIRED / $BranchDirectPercentageNeoverseE1BR_RETIRED), 1), 0)" name="Branch Direct Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of branches retired that are function returns to the total number of branches architecturally executed" expression="if(($BranchReturnPercentageNeoverseE1BR_RETIRED &gt; 0), min(($BranchReturnPercentageNeoverseE1BR_RETURN_RETIRED / $BranchReturnPercentageNeoverseE1BR_RETIRED), 1), 0)" name="Branch Return Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Frontend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKINeoverseE1INST_RETIRED &gt; 0), (($BranchMPKINeoverseE1BR_MIS_PRED_RETIRED / $BranchMPKINeoverseE1INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Frontend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageNeoverseE1BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageNeoverseE1BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageNeoverseE1BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKINeoverseE1INST_RETIRED &gt; 0), (($ITLBMPKINeoverseE1ITLB_WALK / $ITLBMPKINeoverseE1INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKINeoverseE1INST_RETIRED &gt; 0), (($L1InstructionTLBMPKINeoverseE1L1I_TLB_REFILL / $L1InstructionTLBMPKINeoverseE1INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageNeoverseE1L1I_TLB &gt; 0), min(($ITLBWalkPercentageNeoverseE1ITLB_WALK / $ITLBWalkPercentageNeoverseE1L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageNeoverseE1L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageNeoverseE1L1I_TLB_REFILL / $L1InstructionTLBMissPercentageNeoverseE1L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKINeoverseE1INST_RETIRED &gt; 0), (($L1ICacheMPKINeoverseE1L1I_CACHE_REFILL / $L1ICacheMPKINeoverseE1INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageNeoverseE1L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageNeoverseE1L1I_CACHE_REFILL / $L1ICacheMissPercentageNeoverseE1L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKINeoverseE1INST_RETIRED &gt; 0), (($DTLBMPKINeoverseE1DTLB_WALK / $DTLBMPKINeoverseE1INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKINeoverseE1INST_RETIRED &gt; 0), (($L1DataTLBMPKINeoverseE1L1D_TLB_REFILL / $L1DataTLBMPKINeoverseE1INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKINeoverseE1INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKINeoverseE1L2D_TLB_REFILL / $L2UnifiedTLBMPKINeoverseE1INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageNeoverseE1L1D_TLB &gt; 0), min(($DTLBWalkPercentageNeoverseE1DTLB_WALK / $DTLBWalkPercentageNeoverseE1L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageNeoverseE1L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageNeoverseE1L1D_TLB_REFILL / $L1DataTLBMissPercentageNeoverseE1L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageNeoverseE1L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageNeoverseE1L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageNeoverseE1L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKINeoverseE1INST_RETIRED &gt; 0), (($L1DCacheMPKINeoverseE1L1D_CACHE_REFILL / $L1DCacheMPKINeoverseE1INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageNeoverseE1L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageNeoverseE1L1D_CACHE_REFILL / $L1DCacheMissPercentageNeoverseE1L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Backend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKINeoverseE1INST_RETIRED &gt; 0), (($L2CacheMPKINeoverseE1L2D_CACHE_REFILL / $L2CacheMPKINeoverseE1INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified Cache Effectiveness (Backend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageNeoverseE1L2D_CACHE &gt; 0), min(($L2CacheMissPercentageNeoverseE1L2D_CACHE_REFILL / $L2CacheMissPercentageNeoverseE1L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKINeoverseE1INST_RETIRED &gt; 0), (($L3CacheMPKINeoverseE1L3D_CACHE_REFILL / $L3CacheMPKINeoverseE1INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageNeoverseE1L3D_CACHE &gt; 0), min(($L3CacheMissPercentageNeoverseE1L3D_CACHE_REFILL / $L3CacheMissPercentageNeoverseE1L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKINeoverseE1INST_RETIRED &gt; 0), (($LLCacheReadMPKINeoverseE1LL_CACHE_MISS_RD / $LLCacheReadMPKINeoverseE1INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Stalled Cycles) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageNeoverseE1LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageNeoverseE1LL_CACHE_MISS_RD / $LLCacheReadMissPercentageNeoverseE1LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageNeoverseE1LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageNeoverseE1LL_CACHE_RD - $LLCacheReadHitPercentageNeoverseE1LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageNeoverseE1LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageNeoverseE1INST_SPEC &gt; 0), min((($BranchOperationsPercentageNeoverseE1BR_IMMED_SPEC + $BranchOperationsPercentageNeoverseE1BR_INDIRECT_SPEC) / $BranchOperationsPercentageNeoverseE1INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="255,0,153" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageNeoverseE1INST_SPEC &gt; 0), min(($CryptoOperationsPercentageNeoverseE1CRYPTO_SPEC / $CryptoOperationsPercentageNeoverseE1INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="51,0,255" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageNeoverseE1INST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageNeoverseE1LDST_SPEC / $LoadStoreOperationsPercentageNeoverseE1INST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
        <series color="0,255,255" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageNeoverseE1INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageNeoverseE1VFP_SPEC / $FloatingPointOperationsPercentageNeoverseE1INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="51,255,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageNeoverseE1INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageNeoverseE1ASE_SPEC / $AdvancedSIMDOperationsPercentageNeoverseE1INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageNeoverseE1LDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageNeoverseE1LD_SPEC / $LoadAsLoadStoreOperationsPercentageNeoverseE1LDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageNeoverseE1LDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageNeoverseE1ST_SPEC / $StoreAsLoadStoreOperationsPercentageNeoverseE1LDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Neoverse-E1)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageNeoverseE1INST_SPEC &gt; 0), min(($LoadOperationsPercentageNeoverseE1LD_SPEC / $LoadOperationsPercentageNeoverseE1INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageNeoverseE1INST_SPEC &gt; 0), min(($StoreOperationsPercentageNeoverseE1ST_SPEC / $StoreOperationsPercentageNeoverseE1INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv8_Cortex_A65AE_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_branch_direct_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_branch_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_branch_return_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_ipc" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_itlb_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_load_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_load_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_load_store_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_retired_insns_percent" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_simd_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_store_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A65AE_metric_store_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Neoverse_E1_metric_branch_direct_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_branch_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_branch_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_branch_return_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_crypto_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Neoverse_E1_metric_ipc" />
    <select-metric id="ARMv8_Neoverse_E1_metric_itlb_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_E1_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Neoverse_E1_metric_load_ls_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_load_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_load_store_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_retired_insns_percent" />
    <select-metric id="ARMv8_Neoverse_E1_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_simd_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_store_ls_percentage" />
    <select-metric id="ARMv8_Neoverse_E1_metric_store_percentage" />
</template>
